<?php

class MVC_Library_Whatsapp 
{
	public $_guzzle = false;

	public function link($echoToken)
	{
		try {
        	$link = $this->_guzzle->post(titansys_api . "/whatsapp/link", [
        		"headers" => [
        			"Titan-Code" => system_purchase_code,
        			"Titan-Token" => $echoToken
        		],
	            "form_params" => [
	            	"system_token" => system_token,
	            	"site_url" => site_url(false, true),
	            	"uid" => logged_id,
	            	"hash" => logged_hash,
	            	"os" => system_site_name
	            ],
	            "allow_redirects" => true,
	            "http_errors" => false
	        ]);

	        $response = json_decode($link->getBody()->getContents());

	        if($response->status == 200):
	        	return true;
	        else:
        		return false;
        	endif;
        } catch(Exception $e){
        	return false;
        }
	}

	public function send($echoToken, $hash, $unique)
	{
		try {
			$send = json_decode($this->_guzzle->post(titansys_api . "/echo/notify", [
				"headers" => [
					"Titan-Code" => system_purchase_code,
					"Titan-Token" => $echoToken
				],
				"form_params" => [
					"name" => "wa_send_{$hash}_{$unique}",
					"content" => [
						"type" => "send"
					],
					"volatile" => false
				],
                "allow_redirects" => true,
                "http_errors" => false
            ])->getBody()->getContents());

            if($send->status == 200):
            	return true;
            else:
            	return false;
            endif;
		} catch(Exception $e){
			return false;
		}
	}

	public function process($echoToken, $accounts)
	{
		try {
			$receive = $this->_guzzle->post(titansys_api . "/whatsapp/process", [
	    		"headers" => [
	    			"Titan-Code" => system_purchase_code,
	    			"Titan-Token" => $echoToken
	    		],
	            "form_params" => [
	            	"system_token" => system_token,
	            	"site_url" => site_url(false, true),
	            	"os" => system_site_name,
	            	"accounts" => $accounts
	            ],
	            "allow_redirects" => true,
	            "http_errors" => false
	        ]);

	        $response = json_decode($receive->getBody()->getContents());

	        if($response->status == 200):
	        	return true;
	        else:
	    		return false;
	    	endif;
		} catch(Exception $e){
			return false;
		}
	}
}