<?php
/**
 * PayPal Payment Gateway
 */

return [
    "default" => function(&$request){
        if(!$this->session->has("logged"))
            $this->header->redirect(site_url("dashboard/auth"));

        $plugin = $this->system->getPlugin($request["name"], "directory");

        if(!$plugin)
            $this->pluginError(__("lang_plugin_generic_unabletoprocess"));

        $pluginData = json_decode($plugin["data"], true);

        $getItem = $this->system->getOrder(logged_id, "uid");

        if(!$getItem)
            $this->pluginError(__("lang_plugin_generic_unabletoprocess"));

        $item = json_decode($getItem["data"], true);

        $vars = [
            "title" => __("lang_plugin_paymentpage_processingtitle"),
            "page" => "misc/payment",
            "data" => [
                "plugin" => $pluginData,
                "item" => $item,
            ]
        ];
        
        $this->smarty->assign($vars);
        $this->smarty->display(template . "/header.tpl");
        $this->smarty->display(__DIR__ . "/views/default.tpl");
        $this->smarty->display(template . "/footer.tpl");
    },
    "success" => function(&$request){
        if(!$this->session->has("logged"))
            $this->header->redirect(site_url("dashboard/auth"));

        $vars = [
            "title" => __("lang_title_payment_success"),
            "page" => "misc/payment",
            "data" => [
            	"message" => __("lang_and_dash_pg_pay_line45")
            ]
        ];

        $this->smarty->assign($vars);
        $this->smarty->display(template . "/header.tpl");
        $this->smarty->display(__DIR__ . "/views/success.tpl");
        $this->smarty->display(template . "/footer.tpl");
    },
    "validate" => function(&$request){
        if(!$this->session->has("logged"))
            response(301);

        if(!isset($request["paypal_order_check"], $request["order_id"], $request["hash"], $request["json"]))
            response(500, __("lang_plugin_generic_unabletoprocess"));

        $plugin = $this->system->getPlugin($request["name"], "directory");

        if(!$plugin)
            response(500, __("lang_plugin_generic_unabletoprocess"));

        $pluginData = json_decode($plugin["data"], true);

        $order = false;
        $txn = false;

        try {
            $paypalAuthAPI = $pluginData["sandbox"] == "true" ? "https://api-m.sandbox.paypal.com/v1/oauth2/token" : "https://api-m.paypal.com/v1/oauth2/token"; 
            $paypalCheckoutApi = $pluginData["sandbox"] == "true" ? "https://api-m.sandbox.paypal.com/v2/checkout" : "https://api-m.paypal.com/v2/checkout";
            
            $authResponse = $this->guzzle->post($paypalAuthAPI, [
                "auth" => [
                    $pluginData["client_id"], 
                    $pluginData["secret_key"]
                ],
                "form_params" => [
                    "grant_type" => "client_credentials"
                ],
                "headers" => [
                    "Content-Type" => "application/x-www-form-urlencoded"
                ],
                "http_errors" => false
            ]);

            $authData = json_decode($authResponse->getBody()->getContents());

            $apiResponse = $this->guzzle->get("{$paypalCheckoutApi}/orders/{$request["order_id"]}", [
                "headers" => [
                    "Authorization" => "Bearer {$authData->access_token}",
                    "Content-Type" => "application/json"
                ],
                "http_errors" => false
            ]);

            $apiData = json_decode($apiResponse->getBody()->getContents(), true);

            $order = $apiResponse->getStatusCode() === 200 && !empty($apiData) ? $apiData : false;
            $txn = $order["purchase_units"][0]["payments"]["captures"][0]["id"];
        } catch (Exception $e) {
            response(500, ___(__("lang_plugin_generic_wentwrongerr"), [$e->getMessage()]));
        }

        $getItem = $this->system->getOrder($request["hash"], "hash");

        if(!$getItem)
            response(404, __("lang_plugin_generic_unabletoprocess"));

        $item = json_decode($getItem["data"], true);
        $user = $this->system->getUser($item["data"]["user"]["id"]);

        if(!$user)
            response(500, __("lang_plugin_generic_unabletoprocess"));

        if(!empty($order["id"]) && $order["status"] == "COMPLETED" && $txn):
            $this->system->delete($getItem["uid"], false, "orders");
            
            if($item["type"] < 2):
                if($this->system->checkSubscription($user["id"]) > 0):
                    $transaction = $this->system->create("transactions", [
                        "uid" => $user["id"],
                        "pid" => $item["data"]["package"]["id"],
                        "type" => 1,
                        "price" => $item["data"]["original_price"],
                        "currency" => system_currency,
                        "duration" => $item["data"]["duration"],
                        "provider" => "paypal",
                        "txn" => $txn
                    ]);

                    $filtered = [
                        "pid" => $item["data"]["package"]["id"],
                        "tid" => $transaction
                    ];

                    $subscription = $this->system->getSubscription(false, $user["id"]);

                    $this->system->update($subscription["sid"], $user["id"], "subscriptions", $filtered);
                else:
                    $transaction = $this->system->create("transactions", [
                        "uid" => $user["id"],
                        "pid" => $item["data"]["package"]["id"],
                        "type" => 1,
                        "price" => $item["data"]["original_price"],
                        "currency" => system_currency,
                        "duration" => $item["data"]["duration"],
                        "provider" => "paypal",
                        "txn" => $txn
                    ]);

                    $filtered = [
                        "uid" => $user["id"],
                        "pid" => $item["data"]["package"]["id"],
                        "tid" => $transaction
                    ];

                    $this->system->create("subscriptions", $filtered);
                endif;

                $this->mail->send([
                    "title" => system_site_name,
                    "data" => [
                        "subject" => mail_title(__("lang_response_package_purchasedtitle")),
                        "package" => $item["data"]["package"],
                        "subscription" => $this->system->getSubscription(false, $user["id"])
                    ]
                ], $user["email"], "_mail/subscribe.tpl", $this->smarty);

                if(!empty(system_mailing_address) && in_array("admin_package_buy", explode(",", system_mailing_triggers))):
                    $packageWorth = "{$item["data"]["package"]["price"]} " . system_currency;

                    $mailingContent = <<<HTML
                    <p>Hi there!</p>
                    <p>This is to inform you that <strong>{$user["email"]}</strong> has bought <strong>{$item["data"]["package"]["name"]}</strong> package worth <strong>{$packageWorth}</strong> via <strong>PayPal</strong>.</p> 
                    HTML;

                    $this->mail->send([
                        "title" => system_site_name,
                        "data" => [
                            "subject" => mail_title("Admin Alert Message from " . system_site_name . "!"),
                            "content" => $mailingContent
                        ]
                    ], system_mailing_address, "_mail/default.tpl", $this->smarty);
                endif;
            else:
                $transaction = $this->system->create("transactions", [
                    "uid" => $user["id"],
                    "pid" => 0,
                    "type" => 2,
                    "price" => $item["data"]["credits"],
                    "currency" => system_currency,
                    "duration" => 0,
                    "provider" => "paypal",
                    "txn" => $txn
                ]);

                $this->system->credits($user["id"], "increase", $item["data"]["credits"]);

                $this->mail->send([
                    "title" => system_site_name,
                    "data" => [
                        "subject" => mail_title(__("lang_payment_webhook_paypalcreditsadded")),
                        "credits" => $item["data"]["credits"]
                    ]
                ], $user["email"], "_mail/credits.tpl", $this->smarty);

                if(!empty(system_mailing_address) && in_array("admin_credits_buy", explode(",", system_mailing_triggers))):
                    $mailingContent = <<<HTML
                    <p>Hi there!</p>
                    <p>This is to inform you that <strong>{$user["email"]}</strong> has bought <strong>{$item["data"]["credits"]}</strong> credits via <strong>PayPal</strong>.</p> 
                    HTML;

                    $this->mail->send([
                        "title" => system_site_name,
                        "data" => [
                            "subject" => mail_title("Admin Alert Message from " . system_site_name . "!"),
                            "content" => $mailingContent
                        ]
                    ], system_mailing_address, "_mail/default.tpl", $this->smarty);
                endif;
            endif;

            $this->cache->container("system.transactions");
            $this->cache->clear();
        else:
            $this->mail->send([
                "title" => system_site_name,
                "data" => [
                    "subject" => mail_title(__("lang_payment_transact_failed")),
                    "order" => $txn ?: __("lang_payment_webhook_unknowntn")
                ]
            ], $user["email"], "_mail/failed.tpl", $this->smarty);
        endif;

        response(200);
    }
];